import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(6, 6))

# Define the grid size
rows, cols = 3, 3

# Define the colors for clear, occupied, and painted tiles
clear_color = 'lightgreen'
occupied_color = 'salmon'
painted_white_color = 'white'
painted_black_color = 'black'

# Define the robot color
robot_color = 'white'

# Define the tile status
tile_status = {
    'tile_0-1': 'clear', 'tile_0-2': 'clear', 'tile_0-3': 'clear',
    'tile_1-1': 'painted_white', 'tile_1-2': 'painted_black', 'tile_1-3': 'occupied',
    'tile_2-1': 'painted_black', 'tile_2-2': 'painted_white', 'tile_2-3': 'painted_black',
}

# Define robot position
robot_position = (1, 2)

# Draw the tiles
for row in range(rows):
    for col in range(cols):
        tile_id = f'tile_{row}-{col+1}'
        status = tile_status[tile_id]
        if status == 'occupied':
            color = occupied_color
        elif status == 'painted_white':
            color = painted_white_color
        elif status == 'painted_black':
            color = painted_black_color
        else:
            color = clear_color
        rect = patches.Rectangle((col, rows-row-1), 1, 1, linewidth=1, edgecolor='black', facecolor=color)
        ax.add_patch(rect)
        ax.text(col + 0.5, rows-row-0.5, tile_id, ha='center', va='center', fontsize=8, color='black')

# Draw the robot
row, col = robot_position
circle = patches.Circle((col + 0.5, rows-row-0.5), 0.3, edgecolor='black', facecolor=robot_color)
ax.add_patch(circle)
ax.text(col + 0.5, rows-row-0.7, 'robot1', ha='center', va='center', fontsize=8, color='black')

# Draw available colors
color_rects = {
    'color_white': (3.5, 2.5),
    'color_black': (3.5, 1.5),
}

for color_name, (x, y) in color_rects.items():
    rect = patches.Rectangle((x, y), 0.5, 0.5, linewidth=1, edgecolor='black', facecolor=color_name.split('_')[1])
    ax.add_patch(rect)
    ax.text(x + 0.25, y + 0.25, color_name, ha='center', va='center', fontsize=8, color='black')

# Set limits and labels
ax.set_xlim(0, cols + 1)
ax.set_ylim(0, rows)
ax.set_xticks([])
ax.set_yticks([])

# Add legend
legend_elements = [
    patches.Patch(facecolor=clear_color, edgecolor='black', label='Clear Tile'),
    patches.Patch(facecolor=occupied_color, edgecolor='black', label='Occupied Tile'),
    patches.Patch(facecolor=painted_white_color, edgecolor='black', label='Painted White Tile'),
    patches.Patch(facecolor=painted_black_color, edgecolor='black', label='Painted Black Tile'),
    patches.Patch(facecolor=robot_color, edgecolor='black', label='Robot1 (White)'),
]
ax.legend(handles=legend_elements, loc='upper right', bbox_to_anchor=(1.3, 1))

# Save the figure
plt.savefig('<PATH_REMOVED>', bbox_inches='tight')
plt.show()